# [Feature Name] - Feature Epic

**Labels**: `epic`, `[feature-area-name]`
**Parent Epic**: #[master-epic-number]

---

## Capability Definition

**What users need to accomplish:**
[Describe the capability from the user's perspective - what they can DO when this is complete]

**Who needs this:**
- [User type 1]: [Why they need this capability]
- [User type 2]: [Why they need this capability]

## User Value & Context

**Job to Be Done:**
When I'm [context/situation], I want to [action/capability], so I can [outcome/benefit].

**Current State (Pain Point):**
[Describe what users do today without this capability and why it's problematic]

**Desired State:**
[Describe what users will be able to do with this capability]

**Why This Matters:**
- **User Impact:** [How this improves user experience or outcomes]
- **Business Impact:** [How this advances business/product goals]
- **Strategic Importance:** [How this enables future capabilities or growth]

## Success Criteria

**Primary Success Indicator:**
[Single, measurable outcome that defines success for this capability]
- **Measurement:** [How success will be measured]
- **Target:** [Specific goal with numbers/percentages]

**Secondary Indicators:**
- [Indicator 1]: [Target]
- [Indicator 2]: [Target]

**Definition of Done:**
- [ ] [Acceptance criterion 1]
- [ ] [Acceptance criterion 2]
- [ ] [Acceptance criterion 3]
- [ ] Documentation updated
- [ ] Tests passing
- [ ] Deployed to production/beta

## Technical Approach Overview

**High-Level Architecture:**
[Describe the general approach at a conceptual level - not step-by-step implementation]

**Key Components:**
- **[Component 1]**: [Purpose and responsibility]
- **[Component 2]**: [Purpose and responsibility]
- **[Component 3]**: [Purpose and responsibility]

**Integration Points:**
- [How this integrates with existing systems/features]
- [External dependencies or APIs]
- [Impact on other capabilities]

**Data Model Changes:**
[High-level description of new tables, fields, or relationships needed]

## Constraints & Requirements

**Must Have:**
- [Non-negotiable requirement 1]
- [Non-negotiable requirement 2]

**Should Have:**
- [Strongly desired but not blocking]

**Out of Scope:**
- [Explicitly not included in this epic]

## Open Questions & Decisions

_Track questions that need answering and decisions that need to be made_

| Question | Options | Decision Date | Owner | Resolution |
|----------|---------|---------------|-------|------------|
| [Question 1] | [Option A vs Option B] | YYYY-MM-DD | [Who decides] | [Decision made] |
| [Question 2] | [Option A vs Option B] | TBD | [Who decides] | TBD |

## Implementation Tasks

_Implementation tasks will be created just-in-time as this epic becomes active. Link them here as they're created._

### Planned Tasks (Not Yet Created):
- [ ] [High-level task 1]
- [ ] [High-level task 2]
- [ ] [High-level task 3]

### Created Tasks:
- #[task-number] [Task name]
- #[task-number] [Task name]

## Timeline

**Estimated Duration:** [X weeks]
**Target Start:** [Date or week number]
**Target Completion:** [Date or week number]

**Dependencies:**
- Depends on: #[epic-number] [Epic name]
- Blocks: #[epic-number] [Epic name]

## Testing & Validation

**Testing Approach:**
- [Unit testing strategy]
- [Integration testing approach]
- [User acceptance testing plan]

**Validation Plan:**
[How you'll know this capability actually works for users]

**Beta/Early Access:**
[If applicable, plan for early user testing]

## Risks & Mitigation

**Technical Risks:**
1. **[Risk 1]**: [Description]
   - **Likelihood:** [Low/Medium/High]
   - **Impact:** [Low/Medium/High]
   - **Mitigation:** [How to address]

**Usability Risks:**
1. **[Risk 1]**: [Description]
   - **Likelihood:** [Low/Medium/High]
   - **Impact:** [Low/Medium/High]
   - **Mitigation:** [How to address]

## Progress Notes

_Update this section as work progresses to track decisions, learnings, and changes_

**[YYYY-MM-DD]**: [Note about progress, decision, or learning]
**[YYYY-MM-DD]**: [Note about progress, decision, or learning]

## Resources

**Design/Mockups:**
- [Link to designs]

**Reference Documentation:**
- [Link to relevant docs or API documentation]

**Related Issues:**
- [Link to related epics or bugs]

---

**Status**: [Not Started | In Progress | In Review | Complete]
