# [Specific Task Name]

**Labels**: `task`, `[feature-area-name]`
**Parent Epic**: #[feature-epic-number]

---

## Task Description

[Clear, specific description of what needs to be implemented. Be concrete and actionable.]

**Context:**
[Why this task is needed and how it fits into the larger feature epic]

## Technical Details

**Approach:**
[Specific technical approach or implementation strategy]

**Files/Components to Change:**
- `[file-path-1]`: [What changes]
- `[file-path-2]`: [What changes]
- `[file-path-3]`: [What changes]

**New Files/Components to Create:**
- `[file-path]`: [Purpose and description]

**Dependencies:**
- Requires: #[task-number] [Task name] to be complete
- Blocks: #[task-number] [Task name]
- Depends on: [External library, API, or resource]

## Acceptance Criteria

**Functional Requirements:**
- [ ] [Specific, testable criterion 1]
- [ ] [Specific, testable criterion 2]
- [ ] [Specific, testable criterion 3]

**Technical Requirements:**
- [ ] Code follows project style guide
- [ ] Unit tests added/updated
- [ ] Integration tests passing
- [ ] No new TypeScript errors
- [ ] Performance acceptable (if applicable)

**Documentation Requirements:**
- [ ] Code comments added for complex logic
- [ ] API documentation updated (if applicable)
- [ ] README or user docs updated (if user-facing)

## Implementation Notes

**Key Considerations:**
- [Important consideration 1]
- [Important consideration 2]
- [Potential edge cases to handle]

**Potential Challenges:**
- [Challenge 1 and suggested approach]
- [Challenge 2 and suggested approach]

**References:**
- [Link to relevant documentation]
- [Link to example code or prior art]
- [Link to design decisions or ADRs]

## Testing Plan

**Test Cases:**
1. [Test scenario 1]: [Expected outcome]
2. [Test scenario 2]: [Expected outcome]
3. [Test scenario 3]: [Expected outcome]

**Manual Testing Steps:**
1. [Step 1]
2. [Step 2]
3. [Step 3]
4. **Expected Result:** [What should happen]

## Estimated Complexity

**Size**: [Small | Medium | Large]
**Estimated Time**: [X hours/days]

**Complexity Factors:**
- [Factor contributing to complexity]
- [Factor contributing to complexity]

## Completion Checklist

- [ ] Implementation complete
- [ ] Tests written and passing
- [ ] Code reviewed
- [ ] Documentation updated
- [ ] Deployed to dev/staging environment
- [ ] Acceptance criteria verified
- [ ] PR linked: #[pr-number]
- [ ] Related issues updated

## Related Work

**Pull Requests:**
- #[pr-number] [PR title]

**Related Tasks:**
- #[task-number] [Related task]

**Related Bugs:**
- #[bug-number] [Bug fixed by this task]

---

**Assignee**: [Developer name]
**Status**: [To Do | In Progress | In Review | Done]
**Priority**: [Low | Medium | High | Critical]
