# [Project Name] - Master Epic

**Labels**: `epic`, `master`, `documentation`

---

## Executive Summary

[2-3 paragraph overview including:]
- What problem this project solves
- Who has this problem and why it matters
- What success looks like
- Timeline and delivery target

## Success Metrics

**Primary Success Metric:**
[Single, measurable outcome that defines success]

**Baseline:** [Current state]
**Target:** [Goal state with specific numbers]
**Timeline:** [When success will be measured]

**Secondary Metrics:**
- [Metric 1]: Baseline → Target
- [Metric 2]: Baseline → Target
- [Metric 3]: Baseline → Target

## Feature Epics

This master epic is composed of the following feature epics:

- #[issue-number] [Feature Epic 1 Name]
- #[issue-number] [Feature Epic 2 Name]
- #[issue-number] [Feature Epic 3 Name]
- #[issue-number] [Feature Epic 4 Name]
- #[issue-number] [Feature Epic 5 Name]

## Architecture Decisions

**Stack & Technology:**
- [Key technology decisions]
- [Infrastructure choices]
- [Third-party integrations]

**Key Architectural Patterns:**
- [Pattern 1]: [Rationale]
- [Pattern 2]: [Rationale]

## Timeline

**Total Duration:** [X weeks/months]

**Phase Breakdown:**
- **Phase 1 (Week X-Y)**: [Focus area] → See #[epic-numbers]
- **Phase 2 (Week X-Y)**: [Focus area] → See #[epic-numbers]
- **Phase 3 (Week X-Y)**: [Focus area] → See #[epic-numbers]

## Risk Assessment

**Overall Risk:** [Low/Medium/High]

**Key Risks:**
1. **[Risk Category]** (Assessment: [Low/Medium/High])
   - Risk: [Description]
   - Mitigation: [Approach]

2. **[Risk Category]** (Assessment: [Low/Medium/High])
   - Risk: [Description]
   - Mitigation: [Approach]

## Constraints

**Must Have (Non-Negotiable):**
- [Constraint 1]
- [Constraint 2]
- [Constraint 3]

**Out of Scope:**
- [Explicitly NOT solving in this project]
- [Explicitly NOT solving in this project]

## Major Decisions Log

_Update this section as significant decisions are made during implementation_

| Date | Decision | Rationale | Related Epic/Task |
|------|----------|-----------|-------------------|
| YYYY-MM-DD | [Decision] | [Why this was chosen] | #[issue-number] |

## Learnings & Outcomes

_Update this section as the project progresses to capture insights for future reference_

**What Went Well:**
- [Learning 1]
- [Learning 2]

**What Could Be Improved:**
- [Learning 1]
- [Learning 2]

**Unexpected Challenges:**
- [Challenge 1 and how it was resolved]
- [Challenge 2 and how it was resolved]

## Resources

**Documentation:**
- [Link to PRD or requirements doc]
- [Link to design files or mockups]
- [Link to architecture diagrams]

**Related Work:**
- [Link to related projects or prior art]
- [Link to research or discovery work]

---

**Status Tracking:**
- [ ] All feature epics created and linked
- [ ] Architecture decisions documented
- [ ] Beta/validation phase complete
- [ ] Primary success metric achieved
- [ ] Project retrospective complete
