# Agent Team Pattern for Multi-Phase Epics

## When to Use a Team

Create an agent team when:
- 2+ phases can run in parallel (no file-level conflicts)
- Phases are substantial enough that dedicated focus improves quality
- The dependency graph has independent branches

## Team Structure

```
Team Lead (you)
├── Phase Agent 1  →  Phase issue #A
├── Phase Agent 2  →  Phase issue #B
├── Phase Agent 3  →  Phase issue #C
└── ...
```

**Team lead responsibilities**:
- Create the epic and all phase issues
- Create tasks with correct `blockedBy` dependencies
- Spawn agents and assign phases
- Monitor progress and verify completions
- Handle merge coordination between phases
- Mark tasks complete when agents stall (agents sometimes don't self-report)

**Phase agent responsibilities**:
- Read the assigned phase issue thoroughly
- Invoke the `test-driven-development` skill
- Follow TDD strictly: RED → GREEN → REFACTOR
- Work within the phase's declared file boundaries
- Report completion to team lead
- Flag any unexpected dependencies or conflicts

## Dependency Cascade

Define all tasks and dependencies upfront, then let the cascade handle ordering:

```
Phase 1 (no blockers)     → Start immediately
Phase 2 (blocked by 1)    → Starts when 1 completes
Phase 3 (blocked by 2)    → Starts when 2 completes
Phase 4 (blocked by 2)    → Starts when 2 completes (parallel with 3)
Phase 5 (blocked by 3, 4) → Starts when both 3 AND 4 complete
```

Phases 3 and 4 run in parallel because they share a dependency (Phase 2) but don't depend on each other.

## Setup Checklist

1. **Create team**: `TeamCreate` with descriptive name
2. **Create all tasks**: One per phase, with `blockedBy` relationships
3. **Start Phase 1**: Spawn agent, assign the unblocked task
4. **Cascade**: As phases complete, assign newly unblocked phases to agents
5. **Verify each phase**: Before unblocking dependents, confirm:
   - Tests pass (`npm test`)
   - TypeScript clean (`npm run typecheck`)
   - PR merged to main
6. **Shutdown**: Send `shutdown_request` to all agents when epic is complete
7. **Cleanup**: `TeamDelete` to remove team files

## File Conflict Resolution

When two parallel phases must touch the same file:

| Conflict Type | Strategy |
|--------------|----------|
| Both add new exports to an index file | Safe in parallel — merge will auto-resolve |
| Both modify the same function | Serialize these phases |
| One adds a new file, other reads it | The reader must depend on the creator |
| Both add new test files | Safe in parallel — no overlap |

## Lessons Learned

- Agents sometimes don't mark tasks complete even when work is done — team lead should verify and mark complete
- Create ALL tasks with dependencies upfront before spawning any agents
- Phases with no interdependencies should run simultaneously to maximize throughput
- Each phase should merge to main before dependent phases begin (keeps the base clean)
- Keep phase scope tight — a phase that tries to do too much becomes hard to parallelize
